; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below.
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------
;The following two have the same name, but different motion.
;Either one will be detected by a "command = TripleKFPalm" trigger.
;Time is set to 20 (instead of default of 15) to make the move
;easier to do.
;

[Command]
name = "CelestialBeam"
command = ~F, D, B, F, D, B, x+y
time = 40

[Command]
name = "HoneyRush"
command = ~D, B, D, F, x
time = 20

[Command]
name = "HoneyRush"   ;Same name as above
command = ~D, B, D, F, y
time = 20


;-| Special Motions |------------------------------------------------------
[Command]
name = "QCF_xy"
command = ~D, F, x+y

[Command]
name = "QCF_x"
command = ~D, F, x

[Command]
name = "QCF_y"
command = ~D, F, y

[Command]
name = "QCB_xy"
command = ~D, B, x+y

[Command]
name = "QCB_x"
command = ~D, B, x

[Command]
name = "QCB_y"
command = ~D, B, y

[Command]
name = "FDF_ab"
command = ~F, D, F, a+b

[Command]
name = "FDF_a"
command = ~F, D, F, a

[Command]
name = "FDF_b"
command = ~F, D, F, b

[Command]
name = "QCF_ab"
command = ~D, F, a+b

[Command]
name = "QCF_a"
command = ~D, F, a

[Command]
name = "QCF_b"
command = ~D, F, b

[Command]
name = "QCB_ab"
command = ~D, B, a+b

[Command]
name = "QCB_a"
command = ~D, B, a

[Command]
name = "QCB_b"
command = ~D, B, b

;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = z
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1
;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1, Label]           ;Change Label to any name you want to use to
;                               ;identify the state with.
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in.


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;============================================================================
;AI Start
;============================================================================

[State -1, AI ON]
type = Varset
triggerall = var(59) <= 0
triggerall = roundstate <= 2
triggerall = alive
triggerall = !ishelper
trigger1 = AIlevel
var(59) = -1

[State -1, AI OFF]
type = Varset
triggerall = var(59)
trigger1 = !AILevel
trigger2 = !alive
trigger3 = roundstate > 2
trigger3 = (stateno = 195 || stateno = 1040 || !win && !winko) || roundstate = 4
var(59) = 0

[State -1, AI Level Set]
type = VarSet
trigger1 = var(59) != 0
var(59) = ifelse((var(44)=[1,10]),var(44),10)
ignorehitpause = 1

;Simul/Tag Detection (credits to Poyochan)

[State -1, Simul/Tag] 
Type = varset
triggerall = !ishelper
trigger1 = numenemy = 1
var(57) = 0
ignorehitpause = 1

[State -1, Simul/Tag]
Type = varset
triggerall = !ishelper
trigger1 = numenemy = 2
trigger1 = enemynear(0),alive
trigger1 = enemynear(1),alive
var(57) = IfElse(((Abs(Pos X - EnemyNear(0),Pos X)) < (Abs(Pos X - EnemyNear(1),Pos X))),0,1)
ignorehitpause = 1

[State -1, Simul/Tag]
Type = varset
triggerall = !ishelper
trigger1 = numenemy = 2
trigger1 = !enemynear(0),Alive || !enemynear(1),Alive
var(57) = IfElse(EnemyNear(0),Alive,0,1)
ignorehitpause = 1

[State -1, Enemy X-Velocity]
type = varset
triggerall = !ishelper
triggerall = facing != enemynear(var(57)),facing
trigger1 = fvar(17) != enemynear(var(57)),vel x
fvar(17) = enemynear(var(57)),vel x 

[State -1, Enemy X-Velocity]
type = varset
triggerall = !ishelper
triggerall = facing = enemynear(var(57)),facing
trigger1 = fvar(17) != enemynear(var(57)),vel x
fvar(17) = -enemynear(var(57)),vel x 

[State -1, Enemy X-Velocity]
type = varset
triggerall = !ishelper
triggerall = fvar(17) != 0
trigger1 = enemynear(var(57)),vel x = 0
fvar(17) = 0
ignorehitpause = 1

;Combi Condition

[State -1, Combo condition Reset]
type = VarSet
trigger1 = 1
var(1) = 0

[State -1, Combo condition Check]
type = VarSet
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = movecontact
var(1) = 1

;For Coding

[State -1, AI Reading]
type = DisplayToClipboard
trigger1 = 1
text = "X = %d, Y = %d, 6a = %d, 6a2 = %d, C = %d"
params = p2bodydist X, p2bodydist Y, var(38), var(39), var(54)
ignorehitpause = 1
persistent = 1

;Defaults off

[State -1, Flags]
type = AssertSpecial
trigger1 = var(59) > 3
flag = nowalk

[State -1, Flags]
type = AssertSpecial
triggerall = !ishelper
trigger1 = var(59) > 3
flag = nostandguard
flag2 = nocrouchguard
flag3 = noairguard

;AI Helpers

[State -1, AI Config]
type=helper
triggerall = !ishelper
trigger1=!NumHelper(9740)
trigger1=alive
;Trigger1=PrevStateNo=(5900)
helpertype=normal
name="AI Config"
stateno=9740
ID=9740
pos=9999,9999
keyctrl=0
pausemovetime=0
supermovetime=0

[State -1, AI Counter Memory]
type=helper
triggerall = !ishelper
trigger1=!NumHelper(9741)
trigger1=roundstate=2
trigger1=alive
trigger1=var(59)
;Trigger1=PrevStateNo=(5900)
helpertype=normal
name="AI Counter Memory Helper"
stateno=9741
ID=9741
pos=9999,9999
keyctrl=0
pausemovetime=0
supermovetime=0

[State -1, AI Counter Memory]
type=helper
triggerall = !ishelper
trigger1=!NumHelper(9741)
trigger1=roundstate=2
trigger1=alive
trigger1=var(59)
;Trigger1=PrevStateNo=(5900)
helpertype=normal
name="AI Counter Memory Helper"
stateno=9741
ID=9741
pos=9999,9999
keyctrl=0
pausemovetime=0
supermovetime=0

[State -1, AI Guarding System]
type=helper
triggerall = !ishelper
trigger1=!NumHelper(9742)
trigger1=roundstate=2
trigger1=alive
trigger1=var(59)
;Trigger1=PrevStateNo=(5900)
helpertype=normal
name="AI Guarding Helper"
stateno=9742
ID=9742
pos=9999,9999
keyctrl=0
pausemovetime=0
supermovetime=0

[state -1, AI Detect Projectile System]
type = helper
triggerall = !ishelper
trigger1 = var(59)
trigger1 = !numhelper(33333333)
name = "AI Detect Projectile System"
ID = 33333333
stateno = 33333333
postype = p1
ownpal = 1
keyctrl = 0
size.xscale = 1.0
size.yscale = 1.0
supermovetime = 2147483647
pausemovetime = 2147483647
ignorehitpause = 1

;AI Variables

[State -1, Guarding Check (OFF)]
type = VarSet
triggerall = var(59) && numenemy
triggerall = numhelper(9742)
trigger1 = enemynear(var(57)), statetype != A
trigger1 = enemynear(var(57)), stateno != helper(9742),var(59) || enemynear(var(57)), stateno = 0
fvar(14) = 0

;This Guard Method uses Poyochan's as a base. Huge Credits for him for creating the original method system
[State -1, Guarding Check (starters)]
type = VarSet
triggerall = var(59) && numenemy
trigger1 = enemynear(var(57)), statetype = A
trigger2 = numhelper(9742)
trigger2 = enemynear(var(57)), stateno != 0
trigger2 = enemynear(var(57)), stateno = helper(9742),var(59)
fvar(14) = 1

[State -1, Grab Cooldown set]
type = VarSet
trigger1 = stateno = 800
fvar(16) = 35

[State -1, Grab Cooldown down]
type = VarAdd
triggerall = stateno != 800
triggerall = movetype != H
trigger1 = fvar(16) > 0
fvar(16) = -1

[State -1, Grab Cooldown time off]
type = Varset
trigger1 = fvar(16) < 0
fvar(16) = 0

[State -1, Flame Cooldown set]
type = VarSet
triggerall = numhelper(9740)
trigger1 = stateno = [1100,1120]
trigger1 = prevstateno != [200,499]
fvar(13) = helper(9740),var(5)

[State -1, Flame Cooldown down]
type = VarAdd
triggerall = stateno != [1100,1120]
triggerall = movetype != H
trigger1 = fvar(13) > 0
fvar(13) = -1

[State -1, Flame Cooldown time off]
type = Varset
trigger1 = fvar(13) < 0
fvar(13) = 0

[State -1, AI Air Defensive off]
type = VarSet
trigger1 = statetype = A
trigger1 = movetype = H
fvar(22) = 1

[State -1, AI Air Defensive off]
type = VarSet
trigger1 = statetype != A
fvar(22) = 0

[State -1, AI Enemy Idle State Detecttor]
type = VarAdd
trigger1 = (enemynear(var(57)), movetype = I)
fvar(23) = 1

[State -1, AI Enemy Idle State off]
type = VarSet
trigger1 = (enemynear(var(57)), movetype != I)
fvar(23) = 0

[State -1, Record Time if Zoned]
type = VarAdd
trigger1 = p2bodydist X>=250
fvar(31) = 1

[State -1, Add more time if A move is Guarded]
type = VarAdd
triggerall = p2bodydist X>=250
triggerall = time = 1
trigger1 = stateno = 150
trigger2 = stateno = 152
fvar(31) = 15

[State -1, Add more time after Knockdown]
type = VarAdd
triggerall = p2bodydist X>=250
triggerall = time = 1
trigger1 = prevstateno = 6120
fvar(31) = 50

[State -1, Zoning Detector Off]
type = VarSet
trigger1 = p2bodydist X<250
fvar(31) = 0

[State -1, Record Time if Close]
type = VarAdd
trigger1 = enemynear(var(57)), statetype != L
trigger1 = p2bodydist X<=120
fvar(32) = 1

[State -1, Remove Time]
type = VarSet
trigger1 = enemynear(var(57)), statetype = L
trigger2 = p2bodydist X>120
fvar(32) = 0

;AI Combo Counting Vars

[State -1, Dizzy Cancel Amount]
type = VarSet
trigger1 = var(51) =[1,3]
var(52) = var(51)-1

[State -1, Dizzy Cancel Amount]
type = VarSet
trigger1 = var(51) !=[1,3]
var(52) = 2

[State -1, Dizzy Cancel Amount]
type = VarSet
trigger1 = var(51) =[1,3]
var(52) = var(51)-1

;AI Action Cancel

[State -1, AI Cancel Liedown Punish]
type = VarSet
triggerall = fvar(12) = 0
trigger1 = (stateno = 430 || stateno = 440) && enemynear(var(57)), statetype = L && time = 1
trigger2 = enemynear(var(57)), stateno = 5120
trigger3 = stateno = 440 && movehit
fvar(12) = 1

[State -1, AI Cancel Liedown Punish Off]
type = VarSet
trigger1 = enemynear(var(57)), statetype != L
trigger1 = enemynear(var(57)), movetype != H
trigger1 = enemynear(var(57)), stateno != 5120
fvar(12) = 0

;AI Combos

[State -1, AI General Combo Var Off]
type = VarSet
trigger1 = var(59) < 4 || roundstate != 2
trigger2 = enemynear(var(57)), statetype = L
trigger3 = movetype = H || enemynear(var(57)), movetype != H
trigger4 = enemynear(var(57)), stateno = [5200,5299]
var(54) = 0

[State -1, AI Dizzy Cancel Combo]
type = VarSet
triggerall = var(59) > 3 && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype = H
triggerall = prevstateno = 1011
trigger1 = stateno = [6061,6062]
var(54) = 1
ignorehitpause = 1

[State -1, AI Dizzy Cancel Combo Off]
type = VarSet
triggerall = var(54) = 1
trigger1 = enemynear(var(57)), statetype = A || enemynear(var(57)), statetype = L
trigger2 = movetype = A && time = 1 && (stateno != [6061,6062]) && stateno != 100
var(54) = 0

[State -1, AI 236xy Combo]
type = VarSet
triggerall = var(59) > 3 && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = A
triggerall = enemynear(var(57)), movetype = H
triggerall = movehit = 1
trigger1 = stateno = 1020
var(54) = 2

[State -1, AI 236xy Combo Off]
type = VarSet
triggerall = var(54) = 2
trigger1 = enemynear(var(57)), statetype != A || enemynear(var(57)), statetype = L
trigger2 = movetype = A && time = 1
trigger2 = stateno != 1020
var(54) = 0

;AI States

[State -1, AI 2a/2b (Knockdown Punish)]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = !var(54)
triggerall = enemynear(var(57)), alive
triggerall = enemynear(var(57)), statetype = L && enemynear(var(57)), stateno != 5120 && enemynear(var(57)), stateno != 5150
triggerall = fvar(12) = 0
triggerall = ctrl || (stateno = [21,22]) || (stateno = [100,101]) || (stateno = [120,140])
triggerall = p2bodydist X = [-10,185]
triggerall = p2bodydist Y = [-50,100]
trigger1 = random <= var(59) * 50 || var(59) > 6
value = ifelse(p2bodydist X <= 100,430,440)

[State -1, AI 2a (Dizzy Combo)]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = statetype != A
triggerall = ctrl || (stateno = [21,22]) || (stateno = [100,101]) || (stateno = [120,140])
trigger1 = var(54) = 1
trigger1 = p2bodydist X <= 95
value = 430

[State -1, AI 2y (Dizzy Combo)]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = statetype != A
triggerall = ctrl || (stateno = [21,22]) || (stateno = [100,101]) || (stateno = [120,140])
trigger1 = var(54) = 1
value = 410

[State -1, AI 5a (236xy Combo)]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = statetype != A
triggerall = var(54) = 2
triggerall = enemynear(var(57)), statetype = A
triggerall = enemynear(var(57)), movetype = H
triggerall = enemynear(var(57)), vel Y > 0
triggerall = p2bodydist Y >= -160
triggerall = p2bodydist X <= 150
triggerall = enemynear(var(57)), stateno = [1027,1028]
trigger1 = ctrl || (stateno = [21,22]) || (stateno = [100,101]) || (stateno = [120,140])
value = 230

[State -1, AI Run Fwd (236xy Combo)]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = statetype != A
triggerall = var(54) = 2 && !inguarddist
triggerall = p2bodydist X >= 80
trigger1 = ctrl || (stateno = [21,22]) || (stateno = [120,140])
value = 100

[State -1, AI 236236p Counter]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype = A
triggerall = enemynear(var(57)), ctrl = 0
triggerall = enemynear(var(57)), animtime <= -8
triggerall = p2bodydist X = [-10,200]
triggerall = p2dist X >= 0
triggerall = p2bodydist Y = [-150,40]
triggerall = power >= 1000
triggerall = random <= var(59) * 25 || var(59) > 6
trigger1 = ctrl || (stateno = [21,22]) || (stateno = [120,140])
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = movecontact
value = 3000

[State -1, AI 623b Counter]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype = A
triggerall = enemynear(var(57)), ctrl = 0
triggerall = enemynear(var(57)), animtime <= -6
triggerall = p2bodydist X = [-8,50+floor(6*(fvar(17)))]
triggerall = p2bodydist Y = [-150,40]
triggerall = random <= var(59) * 30 || var(59) > 6
trigger1 = ctrl || (stateno = [21,22]) || (stateno = [120,140])
trigger2 = var(1)
value = 1140

[State -1, AI 623b Counter]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype = A
triggerall = enemynear(var(57)), ctrl = 0
triggerall = enemynear(var(57)), animtime <= -12
triggerall = p2bodydist X = [-8,95+floor(12*(fvar(17)))]
triggerall = p2bodydist Y = [-150,40]
triggerall = random <= var(59) * 30 || var(59) > 6
trigger1 = ctrl || (stateno = [21,22]) || (stateno = [120,140])
trigger2 = var(1)
value = 1140

[State -1, AI 2a (Enemy in Hitstun)]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), stateno != [5200,5299]
triggerall = enemynear(var(57)), movetype = H
triggerall = ctrl || (stateno = [21,22]) || (stateno = [120,140])
triggerall = p2bodydist X = [-5,95]
triggerall = p2bodydist Y = [-5,20]
trigger1 = random <= var(59) * 90 || var(59) > 3
value = 430

[State -1, AI 2a (Memory Counter Attempt)]
type = ChangeState
triggerall = var(59) > 5 && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = numhelper(9741)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype = A
triggerall = enemynear(var(57)), ctrl = 0
triggerall = numhelper(9741)
triggerall = enemy, teammode != simul
triggerall = enemynear(var(57)), stateno = helper(9741),var(58)
triggerall = enemynear(var(57)), time < helper(9741),var(59)-8
triggerall = facing != enemynear(var(57)), facing
triggerall = ctrl || (stateno = [21,22]) || (stateno = [120,140])
triggerall = p2bodydist X = [-5,95]
triggerall = p2bodydist Y = [-5,20]
trigger1 = random <= var(59) * 80
value = 430

[State -1, AI 2a (Back Punish)]
type = ChangeState
triggerall = var(59) > 5 && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = numhelper(9741)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype = A
triggerall = enemynear(var(57)), ctrl = 0
triggerall = facing = enemynear(var(57)), facing
triggerall = ctrl || (stateno = [21,22]) || (stateno = [120,140])
triggerall = p2bodydist X = [-5,95]
triggerall = p2bodydist Y = [-5,20]
trigger1 = random <= var(59) * 80 || var(59) > 6
value = 430

[State -1, AI Grab]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = !fvar(16)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype != H
triggerall = enemynear(var(57)), stateno != [5000,5999]
triggerall = enemynear(var(57)), stateno != [35,49]
triggerall = enemynear(var(57)), anim != [35,49]
triggerall = ctrl || (stateno = [21,22]) || (stateno = [100,101]) || (stateno = [120,140])
triggerall = p2bodydist X = [-5,9]
triggerall = p2bodydist Y = [-5,20]
trigger1 = random <= var(59) * 90
value = 800

[State -1, AI Retreat when enemy is knocked down]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = L
triggerall = ctrl || (stateno = [21,22])
triggerall = !inguarddist
triggerall = enemynear(var(57)), numproj <= 0
triggerall = !PlayerIdExist(helper(33333333),var(3))
triggerall = p2bodydist X = [0,60+80*(fvar(12))]
triggerall = backedgebodydist >= 80
trigger1 = random <= var(59) * 80
value = 105

[State -1, AI Jump Fwd]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = ctrl || (stateno = [21,22]) || (stateno = [100,101])|| (stateno = [120,140])
triggerall = !inguarddist
triggerall = !PlayerIdExist(helper(33333333),var(3))
triggerall = p2bodydist X >= 380
trigger1 = random <= var(59) * 5
value = 44

[State -1, AI Jump Fwd]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = ctrl || (stateno = [21,22]) || (stateno = [100,101]) || (stateno = [120,140])
triggerall = !inguarddist
triggerall = !PlayerIdExist(helper(33333333),var(3))
triggerall = p2bodydist X >= 250
trigger1 = random <= var(59) * 5
value = 41

[State -1, AI 236a]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = !fvar(13)
triggerall = statetype != A
triggerall = numhelper(1105)<1
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), stateno != [35,49]
triggerall = enemynear(var(57)), anim != [35,49]
triggerall = (!inguarddist) || (facing = enemynear(var(57)), facing)
triggerall = ctrl || (stateno = [21,22]) || (stateno = [100,101]) || (stateno = [120,140])
triggerall = p2bodydist X >= 250
triggerall = p2bodydist Y = [-30,20]
trigger1 = random <= var(59) * 20 || teammode = simul && random <= var(59) * 40
value = 1100

[State -1, AI 236a]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = !fvar(13)
triggerall = statetype != A
triggerall = numhelper(1105)<1
triggerall = enemynear(var(57)), statetype = L
triggerall = enemynear(var(57)), stateno != 5120
triggerall = (!inguarddist) || (facing = enemynear(var(57)), facing)
triggerall = ctrl || (stateno = [21,22]) || (stateno = [100,101]) || (stateno = [120,140])
triggerall = p2bodydist X >= 100
triggerall = p2bodydist Y = [-30,20]
trigger1 = random <= var(59) * 50 || var(59) > 6 && random <= var(59) * 80
value = 1100

[State -1, AI Run Fwd]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), numproj <= 0
triggerall = !PlayerIdExist(helper(33333333),var(3))
triggerall = !inguarddist
triggerall = ctrl || (stateno = [21,22]) || (stateno = [120,140])
triggerall = p2bodydist Y = [-160,40]
trigger1 = p2bodydist X >= 200
trigger1 = random <= var(59) * 80
value = 100

[State -1, AI jx]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = statetype = A
triggerall = enemynear(var(57)),statetype = A
triggerall = ctrl || (stateno = [120,140])
triggerall = (!inguarddist || facing = enemynear(var(57)), facing) || random <= var(59) * 40
triggerall = p2bodydist X = [-5,70+floor(4*(fvar(17))+floor(4*(vel x)))]
triggerall = p2bodydist Y = [-200-floor(4*(enemynear(var(57)),vel y))+floor(8*(vel Y)),-80-floor(4*(enemynear(var(57)),vel y))+floor(4*(vel Y))]
trigger1 = random <= var(59) * 90-30*(fvar(22))
value = 600

[State -1, AI ja]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = statetype = A
triggerall = enemynear(var(57)), statetype != C || enemynear(var(57)), movetype != A
triggerall = Vel Y > -1-7*(p2bodydist X <= 50+floor(4*(fvar(17)))) || enemynear(var(57)),statetype = A || fvar(22)
triggerall = ctrl || (stateno = [120,140])
triggerall = (!inguarddist || facing = enemynear(var(57)), facing) || random <= var(59) * 40
triggerall = p2bodydist X = [-20,100+floor(4*(fvar(17))+floor(4*(vel x)))]
triggerall = p2bodydist Y = [-80-floor(4*(enemynear(var(57)),vel y))+floor(8*(vel Y)),250-floor(4*(enemynear(var(57)),vel y))+floor(4*(vel Y))]
trigger1 = random <= var(59) * 90-30*(fvar(22))
value = 630

[State -1, AI jb]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = statetype = A
triggerall = enemynear(var(57)), statetype != C || enemynear(var(57)), movetype != A
triggerall = Vel Y > -1-7*(p2bodydist X <= 50+floor(4*(fvar(17)))) || enemynear(var(57)),statetype = A || fvar(22)
triggerall = ctrl || (stateno = [120,140])
triggerall = (!inguarddist || facing = enemynear(var(57)), facing) || random <= var(59) * 40
triggerall = p2bodydist X = [-5,200+floor(4*(fvar(17))+floor(4*(vel x)))]
triggerall = p2bodydist Y = [-80-floor(4*(enemynear(var(57)),vel y))+floor(8*(vel Y)),250-floor(4*(enemynear(var(57)),vel y))+floor(4*(vel Y))]
trigger1 = random <= var(59) * 90-30*(fvar(22))
value = 640

[State -1, AI 2y (Aerial Opponent)]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = A || (p2bodydist Y <= -50)
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), stateno != [5200,5299]
triggerall = (!inguarddist) || (facing = enemynear(var(57)), facing)
triggerall = ctrl || (stateno = [21,22]) || (stateno = [120,140])
triggerall = p2bodydist X = [20,150+floor(9*(fvar(17)))]
triggerall = p2dist X >= 0
triggerall = p2bodydist Y = [-140-floor(9*(enemynear(var(57)),vel y)),-60-floor(9*(enemynear(var(57)),vel y))]
trigger1 = random <= var(59) * 80
value = 410

[State -1, AI 5a (Aerial Opponent)]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = A || (p2bodydist Y <= -50)
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), stateno != [5200,5299]
triggerall = (!inguarddist) || (facing = enemynear(var(57)), facing) || (random <= var(59) * 30)
triggerall = ctrl || (stateno = [21,22]) || (stateno = [120,140])
triggerall = p2bodydist X = [-20,100+floor(6*(fvar(17)))]
triggerall = p2dist X >= 0
triggerall = p2bodydist Y = [-180-floor(6*(enemynear(var(57)),vel y)),-80-floor(6*(enemynear(var(57)),vel y))]
trigger1 = random <= var(59) * 80
value = 230

[State -1, AI 2x (Aerial Opponent)]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = A || (p2bodydist Y <= -50)
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), stateno != [5200,5299]
triggerall = (!inguarddist) || (facing = enemynear(var(57)), facing) || (random <= var(59) * 30)
triggerall = ctrl || (stateno = [21,22]) || (stateno = [120,140])
triggerall = p2bodydist X = [-20,50+floor(2*(fvar(17)))]
triggerall = p2dist X >= 0
triggerall = p2bodydist Y = [-50-floor(2*(enemynear(var(57)),vel y)),20]
trigger1 = random <= var(59) * 80
value = 400

[State -1, AI 2b]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), stateno != [5200,5299]
triggerall = (!inguarddist) || (facing = enemynear(var(57)), facing)
triggerall = ctrl || (stateno = [21,22]) || (stateno = [120,140])
triggerall = p2bodydist X = [140,170]
triggerall = p2bodydist Y = [-20,20]
trigger1 = random <= var(59) * 4
value = 440

[State -1, AI 2a]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), stateno != [5200,5299]
triggerall = (!inguarddist) || (facing = enemynear(var(57)), facing) || (random <= var(59) * 50)
triggerall = ctrl || (stateno = [21,22]) || (stateno = [100,101]) || (stateno = [120,140])
triggerall = p2bodydist X = [-10,95]
triggerall = p2bodydist Y = [-10,20]
trigger1 = random <= var(59) * 90
value = 430

[State -1, AI 2x]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = !var(54)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), stateno != [5200,5299]
triggerall = (!inguarddist) || (facing = enemynear(var(57)), facing) || (random <= var(59) * 50)
triggerall = ctrl || (stateno = [21,22]) || (stateno = [100,101]) || (stateno = [120,140])
triggerall = p2bodydist X = [-10,70]
triggerall = p2bodydist Y = [-80,-11]
trigger1 = random <= var(59) * 90
value = 400

[State -1, AI Dizzy Cancel Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive && numhelper(9740)
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = S
triggerall = enemynear(var(57)), const(size.head.pos.y) <= -65
triggerall = enemynear(var(57)), movetype = H
triggerall = !var(54)
triggerall = power > 770 && var(3) <= var(52)
triggerall = movehit = 1
triggerall = var(59) > 3
trigger1 = stateno = 1011
value = 6061

[State -1, AI EX Special Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive && numhelper(9740)
triggerall = statetype != A
triggerall = enemynear(var(57)), movetype = H
triggerall = !var(54)
triggerall = power > 500
triggerall = movehit = 1
triggerall = var(59) > 3
triggerall = !var(4)
trigger1 = stateno = 1011
value = 1020

[State -1, AI Basic Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 3
trigger1 = stateno = 230
value = 235

[State -1, AI Basic Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 3
trigger1 = stateno = 200 || stateno = 230
trigger2 = stateno = 400 || stateno = 430
trigger2 = enemynear(var(57)), statetype = S
trigger2 = enemynear(var(57)), const(size.head.pos.y) <= -65
value = 410

[State -1, AI Basic Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A || stateno = 430
triggerall = enemynear(var(57)), statetype != L || stateno = 430
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 6
triggerall = power >= 3000
trigger1 = stateno = 200 || stateno = 230
trigger2 = stateno = 400 || stateno = 430
value = 440

[State -1, AI Basic Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = A
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 6
triggerall = power >= 3000
trigger1 = stateno = 200
trigger2 = stateno = 400 || stateno = 430
value = 410

[State -1, AI Hyper Combo (Too Short)]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = S && enemynear(var(57)), const(size.head.pos.y) > -65 || enemynear(var(57)), statetype = C
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 6
triggerall = Power >= 1000
trigger1 = stateno = 200 || stateno = 230
trigger2 = stateno = 400 || stateno = 430
value = 3000

[State -1, AI EX Special Combo (Too Short)]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = S && enemynear(var(57)), const(size.head.pos.y) > -65 || enemynear(var(57)), statetype = C
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 6
triggerall = Power >= 500
trigger1 = stateno = 200 || stateno = 230
trigger2 = stateno = 400 || stateno = 430
value = 1020

[State -1, AI Special Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 25 || var(59) > 3 && random <= var(59) * 50
triggerall = p2bodydist X <= 85
trigger1 = stateno = 200 || stateno = 230
trigger2 = stateno = 400 || stateno = 430
value = 1000

[State -1, AI Basic Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A || stateno = 430
triggerall = enemynear(var(57)), statetype != L || stateno = 430
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 3
trigger1 = stateno = 200 || stateno = 230
trigger2 = stateno = 400 || stateno = 430
value = 440

[State -1, AI Hyper Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A || stateno= 440
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype = H
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 6
triggerall = power >= 3000
trigger1 = stateno = 210 || stateno = 410 || stateno = 240 || stateno = 236 && animelemtime(6) >= 1 || stateno = 440
value = 3050

[State -1, AI Special Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype = H
triggerall = enemynear(var(57)), life <= 50
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 3
trigger1 = stateno = 210 || stateno = 410 || stateno = 240 || stateno = 236 && animelemtime(6) >= 1
value = 1170

[State -1, AI Hyper Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype = H
triggerall = movehit = 1
triggerall = !var(54)
triggerall = power >= 1000 && var(3) >= 1 && power <= 1400 || power >= 1000 && var(3) > var(52)
triggerall = random <= var(59) * 25 && var(59) < 4 || var(59) > 6 && (random <= var(59) * 75 || var(3) > var(52))
trigger1 = stateno = 210 || stateno = 410 || stateno = 240 || stateno = 236 && animelemtime(6) >= 1
value = 3000

[State -1, AI Special Combo (Dizzy Combo Setup)]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype = H
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 6
triggerall = power >= 350 && var(3) <= var(52)
trigger1 = stateno = 210 || stateno = 410 || stateno = 240 || stateno = 236 && animelemtime(6) >= 1
value = 1010

[State -1, AI Hyper Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype = H
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 6
triggerall = power >= 1000
trigger1 = stateno = 210 || stateno = 410 || stateno = 240 || stateno = 236 && animelemtime(6) >= 1
value = 3000

[State -1, AI Special Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2 && numhelper(9740)
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype = H
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * helper(9740),var(10)
trigger1 = stateno = 210 || stateno = 410 || stateno = 240 || stateno = 236 && animelemtime(6) >= 1
value = 1010

[State -1, AI Special Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = enemynear(var(57)), movetype = H
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 3
trigger1 = stateno = 210 || stateno = 410 || stateno = 240 || stateno = 236 && animelemtime(6) >= 1
value = 1170

[State -1, AI Special Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = A
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 3
triggerall = !fvar(12)
trigger1 = stateno = 440
trigger1 = p2bodydist X <= 55
value = 1000

[State -1, AI Special Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = A
triggerall = enemynear(var(57)), movetype = H
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 3
triggerall = !fvar(12)
trigger1 = stateno = 440
trigger1 = p2bodydist X <= 80
value = 1140

[State -1, AI Special Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = movehit = 1
triggerall = !var(54)
triggerall = numhelper(1105)<1
triggerall = random <= var(59) * 50 || var(59) > 3
trigger1 = stateno = 440
value = 1100

[State -1, AI Special Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = A
triggerall = enemynear(var(57)), movetype = H
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 3
trigger1 = stateno = 236 && animelemtime(6) >= 1
value = ifelse(random<=500,1030,1140)

[State -1, AI Special Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = A
triggerall = enemynear(var(57)), movetype = H
triggerall = movehit = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 3
trigger1 = stateno = 410
value = 1140

[State -1, AI Guard Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype = A
triggerall = moveguarded = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 3
trigger1 = stateno = 200 || stateno = 230
trigger2 = stateno = 400 || stateno = 430
value = 410

[State -1, AI Guard Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = moveguarded = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 3
trigger1 = stateno = 200 || stateno = 230
trigger2 = stateno = 400 || stateno = 430
value = 440

[State -1, AI Guard Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = moveguarded = 1
triggerall = !var(54)
triggerall = numhelper(1105)<1
triggerall = random <= var(59) * 25 || var(59) > 3 && random <= var(59) * 50
trigger1 = stateno = 210 || stateno = 240
trigger2 = stateno = 410 || stateno = 440
value = 1100

[State -1, AI Guard Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), statetype != A
triggerall = enemynear(var(57)), statetype != L
triggerall = moveguarded = 1
triggerall = !var(54)
triggerall = random <= var(59) * 50 || var(59) > 3
trigger1 = stateno = 210 || stateno = 240
trigger2 = stateno = 410 || stateno = 440
value = ifelse(p2bodydist X <= 75,1000,1010)

[State -1, AI Aerial Combo]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = alive && numhelper(9740)
triggerall = statetype = A
triggerall = movehit = 1
triggerall = random <= var(59) * 50 || var(59) > 3
trigger1 = stateno = 600 || stateno = 630
value = 640

[State -1, AI Anti-Projectile]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = statetype != A
triggerall = ctrl || (stateno = [21,22]) || (stateno = [120,140])
triggerall = PlayerIdExist(helper(33333333),var(3))
triggerall = PlayerID(helper(33333333),var(3)), pos y > -160
triggerall = PlayerID(helper(33333333),var(3)), vel x != 0
triggerall = PlayerID(helper(33333333),var(3)), p2bodydist X >= 50+5*(PlayerID(helper(33333333),var(3)), Vel X)*(facing*PlayerID(helper(33333333),var(3)), facing*-1)
triggerall = PlayerID(helper(33333333),var(3)), p2bodydist X <= 130+5*(PlayerID(helper(33333333),var(3)), Vel X)*(facing*PlayerID(helper(33333333),var(3)), facing*-1)
triggerall = p2bodydist X >= 250
trigger1 = random <= var(59) * 15
value = ifelse(p2bodydist X >= 380,44,41)

[State -1, AI Anti-Projectile]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = statetype != A
triggerall = enemynear(var(57)), numproj > 0
triggerall = inguarddist
triggerall = ctrl || (stateno = [21,22]) || (stateno = [120,140])
triggerall = p2bodydist X >= 250
trigger1 = random <= var(59) * 5
value = ifelse(p2bodydist X >= 380,44,41)

[State -1, AI Guard]
type = ChangeState
triggerall = roundstate = 2
triggerall = alive
triggerall = inguarddist
triggerall = stateno != [120,155]
triggerall = enemynear(var(57)), hitdefattr != SCA,AT
triggerall = ctrl || (stateno = [21,22]) || (stateno = [100,101])
trigger1 = var(59) = [1,3]
trigger1 = random <= var(59) * 25
trigger2 = var(59) = [4,6]
trigger2 = random <= var(59) * 50
trigger3 = var(59) >= 7
value = 120

[State -1, AI Dizzy GC]
type = ChangeState
triggerall = var(59) && roundstate = 2
triggerall = !ishelper
triggerall = alive
triggerall = statetype != A
triggerall = power > 1000
triggerall = stateno = 150 || stateno = 152
triggerall = p2bodydist X >= 250
trigger1 = random <= var(59) * 20
trigger2 = var(59) > 6
trigger2 = life <= 200 || fvar(31) >= 200
value = ifelse(stateno=150,6071,6072)

[State -1, AI Taunt]
type = ChangeState
triggerall = var(59) && roundstate = 3
triggerall = alive
triggerall = statetype != A
triggerall = win || winko
triggerall = stateno != 195
triggerall = prevstateno != 195
trigger1 = ctrl || (stateno=[21,22]) || (stateno = [100,101])
value = ifelse(random<=200,1040,195)

[State -1, AI Walk Fwd]
type = ChangeState
triggerall = var(59) > 3 && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = stateno != [100,155]
triggerall = stateno != 21
triggerall = !inguarddist
triggerall = p2dist X >= 0
trigger1 = ctrl
trigger1 = p2bodydist X >= -3
trigger1 = enemynear(var(57)), statetype != L && enemynear(var(57)), statetype != A
trigger2 = ctrl || stateno = 22
trigger2 = enemynear(var(57)), statetype = L
trigger2 = (p2bodydist X >= 140)
trigger3 = ctrl || stateno = 22
trigger3 = enemynear(var(57)), statetype != L && enemynear(var(57)), statetype != A
trigger3 = (p2bodydist X >= 180) || (random <= var(59) * 5 && time >= 30) || (enemynear(var(57)), movetype = H) || (enemynear(var(57)), time >= 25 && enemynear(var(57)), statetype != A) || (facing = enemynear(var(57)), facing) || (fvar(23) >= 30)
trigger3 = (p2bodydist X > 55) || backedgedist < 10 && time >= 30 || enemynear(var(57)), movetype = H
trigger4 = ctrl || stateno = 22
trigger4 = enemynear(var(57)), statetype = A
trigger4 = (p2bodydist X >= 55)
value = 21

[State -1, AI Walk Back]
type = ChangeState
triggerall = var(59) > 3 && roundstate = 2
triggerall = alive
triggerall = statetype != A
triggerall = stateno != [100,155]
triggerall = stateno != 22
triggerall = !inguarddist
triggerall = p2dist X >= 0
trigger1 = ctrl || stateno = 21
trigger1 = p2bodydist X = [-5,40]
trigger1 = random <= var(59) * 20 || (p2bodydist X < 5)
trigger1 = enemynear(var(57)), movetype != H
trigger1 = enemynear(var(57)), statetype != L && enemynear(var(57)), statetype != A && facing != enemynear(var(57)), facing
trigger1 = enemynear(var(57)), time < 60 && fvar(23) < 60
trigger1 = backedgedist > 10
trigger1 = enemynear(var(57)), movetype != H
trigger2 = ctrl || stateno = 21
trigger2 = enemynear(var(57)), statetype = L
trigger2 = (p2bodydist X <= ifelse(ctrl,139,90))
trigger3 = ctrl || stateno = 21
trigger3 = enemynear(var(57)), statetype = A
trigger3 = (p2bodydist X <= 20)
value = 22

[State -1, AI Walk To Stand]
type = ChangeState
triggerall = stateno = [21,22]
trigger1 = var(59) < 4
trigger2 = roundstate != 2
trigger3 = inguarddist
trigger4 = p2dist X < 0
value = 0
ctrl = 1

;============================================
;AI End
;============================================

;---------------------------------------------------------------------------
;Celestial Beam (Hyper)
[State -1, Celestial Beam (Hyper)]
type = ChangeState
value = 3050
triggerall = var(59) < 4
triggerall = command = "CelestialBeam"
triggerall = power >= 3000
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = movecontact

;---------------------------------------------------------------------------
;Honey Rush (Hyper)
[State -1, Honey Rush (Hyper)]
type = ChangeState
value = 3000
triggerall = var(59) < 4
triggerall = command = "HoneyRush"
triggerall = power >= 1000
trigger1 = statetype != A
trigger1 = ctrl = 1
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = movecontact

;---------------------------------------------------------------------------
;Spin Knuckle (EX)
[State -1, Spin Knuckle (EX)]
type = ChangeState
value = 1050
triggerall = var(59) < 4
triggerall = command = "QCB_xy"
triggerall = power >= 500
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Spin Knuckle (Light)
[State -1, Spin Knuckle (Light)]
type = ChangeState
value = 1030
triggerall = var(59) < 4
triggerall = command = "QCB_x"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Spin Knuckle (Strong)
[State -1, Spin Knuckle (Strong)]
type = ChangeState
value = 1040
triggerall = var(59) < 4
triggerall = command = "QCB_y"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Beat Knuckle (EX)
[State -1, Beat Knuckle (EX)]
type = ChangeState
value = 1020
triggerall = var(59) < 4
triggerall = command = "QCF_xy"
triggerall = power >= 500
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Beat Knuckle (Light)
[State -1, Beat Knuckle (Light)]
type = ChangeState
value = 1000
triggerall = var(59) < 4
triggerall = command = "QCF_x"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Beat Knuckle (Strong)
[State -1, Beat Knuckle (Strong)]
type = ChangeState
value = 1010
triggerall = var(59) < 4
triggerall = command = "QCF_y"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Heavy Blow (EX)
[State -1, Heavy Blow (EX)]
type = ChangeState
value = 1180
triggerall = var(59) < 4
triggerall = command = "QCB_ab"
triggerall = power >= 500
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Heavy Blow (Strong)
[State -1, Heavy Blow (Strong)]
type = ChangeState
value = 1170
triggerall = var(59) < 4
triggerall = command = "QCB_b"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Heavy Blow (Light)
[State -1, Heavy Blow (Light)]
type = ChangeState
value = 1160
triggerall = var(59) < 4
triggerall = command = "QCB_a"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Burning Rave (EX)
[State -1, Burning Rave (EX)]
type = ChangeState
value = 1150
triggerall = var(59) < 4
triggerall = command = "FDF_ab"
triggerall = power >= 500
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Burning Rave (Strong)
[State -1, Burning Rave (Strong)]
type = ChangeState
value = 1140
triggerall = var(59) < 4
triggerall = command = "FDF_b"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Burning Rave (Light)
[State -1, Burning Rave (Light)]
type = ChangeState
value = 1130
triggerall = var(59) < 4
triggerall = command = "FDF_a"
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Fire Drive (EX)
[State -1, Fire Drive (EX)]
type = ChangeState
value = 1120
triggerall = var(59) < 4
triggerall = command = "QCF_ab"
triggerall = power >= 500
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Fire Drive (Light)
[State -1, Fire Drive (Light)]
type = ChangeState
value = 1100
triggerall = var(59) < 4
triggerall = command = "QCF_a"
triggerall = numhelper(1105)<1
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
;Fire Drive (Strong)
[State -1, Fire Drive (Strong)]
type = ChangeState
value = 1110
triggerall = var(59) < 4
triggerall = command = "QCF_b"
triggerall = numhelper(1105)<1
trigger1 = var(1) ;Use combo condition (above)

;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
triggerall = !var(59)
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
triggerall = var(59) < 4
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Throw
[State -1, Throw]
type = ChangeState
value = 800
triggerall = var(59) < 4
triggerall = command = "y"
triggerall = statetype = S
triggerall = ctrl
triggerall = stateno != 100
trigger1 = command = "holdfwd"
trigger1 = p2bodydist X < 6
trigger1 = (p2statetype = S) || (p2statetype = C)
trigger1 = p2movetype != H
trigger2 = command = "holdback"
trigger2 = p2bodydist X < 10
trigger2 = (p2statetype = S) || (p2statetype = C)
trigger2 = p2movetype != H

;===========================================================================
;---------------------------------------------------------------------------
;Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = var(59) < 4
triggerall = command = "x"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 
trigger2 = time > 12

;---------------------------------------------------------------------------
;Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = var(59) < 4
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200 || stateno = 230 || stateno = 400 || stateno = 430) && movecontact

;---------------------------------------------------------------------------
;Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = var(59) < 4
triggerall = command = "a"
triggerall =! command = "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 230
trigger2 = time > 12

;---------------------------------------------------------------------------
;Stand Double Kick
[State -1, Stand Double Kick]
type = ChangeState
value = 235
triggerall = var(59) < 4
triggerall = command = "a"
triggerall = command = "holdfwd"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200 || stateno = 230 || stateno = 400 || stateno = 430) && movecontact

;---------------------------------------------------------------------------
;Standing Strong Kick
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = var(59) < 4
triggerall = command = "b"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200 ||  stateno = 230 || stateno = 400 || stateno = 430) && movecontact

;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = var(59) < 4
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = var(59) < 4
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 400
trigger2 = time > 15

;---------------------------------------------------------------------------
;Crouching Strong Punch
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = var(59) < 4
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 200 || stateno = 230 || stateno = 400 || stateno = 430) && movecontact

;---------------------------------------------------------------------------
;Crouching Light Kick
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = var(59) < 4
triggerall = command = "a"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 430 
trigger2 = time > 15

;---------------------------------------------------------------------------
;Crouching Senton
[State -1, Crouching Senton]
type = ChangeState
value = 440
triggerall = var(59) < 4
triggerall = command = "b"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 200 || stateno = 230 || stateno = 400 || stateno = 430) && movecontact

;---------------------------------------------------------------------------
;Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = var(59) < 4
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl = 1
trigger2 = stateno = 600
trigger2 = time > 12

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = var(59) < 4
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = (stateno = 600 || stateno = 630) && movecontact

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = var(59) < 4
triggerall = command = "a"
trigger1 = statetype = A
trigger1 = ctrl 
trigger2 = stateno = 630
trigger2 = time > 30

;---------------------------------------------------------------------------
;Jump Drop Kick
[State -1, Jump Drop Kick]
type = ChangeState
value = 640
triggerall = var(59) < 4
triggerall = command = "b"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = (stateno = 600 || stateno = 630) && movecontact

;---------------------------------------------------------------------------
; Dizzy Cancel (Stand)
[State -1, |Dizzy Cancel Stand|]
type = ChangeState
value = 6060+(statetype = S)
triggerall = !var(59)
triggerall =  movetype != H
triggerall = statetype != C
triggerall = var(3) < 3
triggerall = command = "c" && power > 500
trigger1 = (stateno = [600,699]) || (stateno = [1000,1012]) || (stateno = [1030,1049])
trigger1 = movehit
trigger2 = (stateno = [200,499]) || (stateno = [1100,1110]) || (stateno = [1130,1140])
trigger2 = movehit
trigger3 = numhelper(1105)
trigger3 = helper(1105),movehit = 1

;---------------------------------------------------------------------------
; Dizzy Cancel (Crouch)
[State -1, |Dizzy Cancel Crouch|]
type = ChangeState
value = 6062
triggerall = !var(59)
triggerall =  movetype != H
triggerall = statetype = C
triggerall = var(3) < 3
triggerall = command = "c" && power > 500
trigger1 = (stateno = [600,699]) || (stateno = [1000,1012]) || (stateno = [1030,1049])
trigger1 = movehit
trigger2 = (stateno = [200,499]) || (stateno = [1100,1110]) || (stateno = [1130,1140])
trigger2 = movehit
trigger3 = numhelper(1105)
trigger3 = helper(1105),movehit = 1

;---------------------------------------------------------------------------
; Dizzy Guard Cancel (Air)
[State -1, |Dizzy Guard Cancel Air|]
type = ChangeState
value = 6070
triggerall = !var(59)
triggerall =  movetype = H
triggerall = statetype = A
triggerall = command = "z" && power > 1000
trigger1 = stateno = 154

;---------------------------------------------------------------------------
; Dizzy Guard Cancel (Stand)
[State -1, |Dizzy Guard Cancel Stand|]
type = ChangeState
value = 6071
triggerall = !var(59)
triggerall =  movetype = H
triggerall = statetype = S
triggerall = command = "z" && power > 1000
trigger1 = stateno = 150

;---------------------------------------------------------------------------
; Dizzy Guard Cancel (Crouch)
[State -1, |Dizzy Guard Cancel Crouch|]
type = ChangeState
value = 6072
triggerall = !var(59)
triggerall =  movetype = H
triggerall = statetype = C
triggerall = command = "z" && power > 1000
trigger1 = stateno = 152

;---------------------------------------------------------------------------