;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
; Stand (Default)
[Statedef 0]
type = S
physics = S
sprpriority = 0

[State 0, ChangeAnim]
type = ChangeAnim
trigger1 = anim = 0 && !animtime
value = ifelse(random<900,0,2)

[State 0, ChangeAnim]
type = ChangeAnim
trigger1 = anim = 2 && !animtime
value = 1

[State 0, ChangeAnim]
type = ChangeAnim
trigger1 = anim = 1 && !animtime
value = ifelse(random<900,1,3)

[State 0, ChangeAnim]
type = ChangeAnim
trigger1 = anim = 3 && !animtime
value = 0

[State 0, 1]
type = ChangeAnim
trigger1 = (Anim != [0,3]) && Anim != 5
trigger2 = Anim = 5 && !AnimTime ;Turn anim over
value = 0

[State 0, 2]
type = VelSet
trigger1 = Time = 0
y = 0

[State 0, 3] ;Stop moving if low velocity or 4 ticks pass
type = VelSet
trigger1 = 1
x = 0

[State 0, 4] ;Are you dead?
type = ChangeState
trigger1 = !alive
value = 5050
ctrl = 0


;---------------------------------------------------------------------------
; Stand to Crouch
[Statedef 10]
type    = C
physics = C
anim = 10

[State 10, VelSet]
type = VelSet
trigger1 = 1
x = 0

[State 10, 1]
type = VelMul
trigger1 = Time = 0
x = .75

[State 10, 2] ;Stop moving if low velocity
type = VelSet
trigger1 = 1
x = 0

[State 10, 3]
type = ChangeState
trigger1 = AnimTime = 0
value = 11

;---------------------------------------------------------------------------
; Crouching
[Statedef 11]
type    = C
physics = C
anim = 11
sprpriority = 0

[State 11, 1] ;Change from turning animation
type = ChangeAnim
trigger1 = Anim = 6 && AnimTime = 0
value = 11

[State 11, 2] ;Stop moving if low velocity
type = VelSet
trigger1 = abs(vel x) < Const(movement.crouch.friction.threshold)
x = 0

;---------------------------------------------------------------------------
; Crouch to Stand
[Statedef 12]
type    = S
physics = S
anim = 12

[State 12, 1]
type = ChangeState
trigger1 = AnimTime = 0
value = 0

;---------------------------------------------------------------------------
; Walk
[Statedef 21]
type    = S
physics = S
ctrl = 0
anim = 20
sprpriority = 0

[State 20, PosSet]
type = PosSet
trigger1 = 1
y = 0

[State 20, 1]
type = VelSet
trigger1 = 1
x = const(velocity.walk.fwd.x)

[State 20, 3]
type = ChangeAnim
triggerall = vel x > 0
trigger1 = Anim != 20 && Anim != 5
trigger2 = Anim = 5 && AnimTime = 0
value = 20

[State 20, 4]
type = ChangeAnim
triggerall = vel x < 0
trigger1 = Anim != 21 && Anim != 5
trigger2 = Anim = 5 && AnimTime = 0
value = 21

;---------------------------------------------------------------------------
; Walk
[Statedef 22]
type    = S
physics = S
ctrl = 0
anim = 21
sprpriority = 0

[State 20, PosSet]
type = PosSet
trigger1 = 1
y = 0

[State 20, 1]
type = VelSet
trigger1 = 1
x = const(velocity.walk.back.x)

[State 20, 3]
type = ChangeAnim
triggerall = vel x > 0
trigger1 = Anim != 20 && Anim != 5
trigger2 = Anim = 5 && AnimTime = 0
value = 20

[State 20, 4]
type = ChangeAnim
triggerall = vel x < 0
trigger1 = Anim != 21 && Anim != 5
trigger2 = Anim = 5 && AnimTime = 0
value = 21

;---------------------------------------------------------------------------
; Jump Start
[Statedef 40]
type    = S
physics = S
anim = 40
ctrl = 0
sprpriority = 1
facep2 = 1

[State 40, ChangeState]
type = ChangeState
trigger1 = var(59) > 3
value = 0
ctrl = 1

[State 40, 1]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 40, 2]
type = VarSet
trigger1 = command = "holdfwd"
sysvar(1) = 1

[State 40, 3]
type = VarSet
trigger1 = command = "holdback"
sysvar(1) = -1

[State 0, VelSet]
type = VelSet
trigger1 = AnimElemtime(1)>0
x = 0 

[State 40, 4]
type = VelSet
trigger1 = AnimTime = 0
x = ifelse(sysvar(1)=0, const(velocity.jump.neu.x), ifelse(sysvar(1)=1, const(velocity.jump.fwd.x), const(velocity.jump.back.x)))
y = const(velocity.jump.y)

[State 40, 5]
type = VelSet
trigger1 = AnimTime = 0
trigger1 = prevstateno = 100 ;RUN_FWD
trigger1 = sysvar(1) = 1
x = const(velocity.runjump.fwd.x)

[State 40, 6]
type = ChangeState
trigger1 = AnimTime = 0
value = 50
ctrl = 1

;---------------------------------------------------------------------------
; FJump
[Statedef 41]
type    = S
physics = S
anim = 40
ctrl = 0
sprpriority = 1
facep2 = 1

[State 40, 1]
type = VarSet
trigger1 = 1
sysvar(1) =1

[State 0, VelSet]
type = VelSet
trigger1 = AnimElemtime(1)>0
x = 0 

[State 40, 4]
type = VelSet
trigger1 = AnimTime = 0
x = ifelse(sysvar(1)=0, const(velocity.jump.neu.x), ifelse(sysvar(1)=1, const(velocity.jump.fwd.x), const(velocity.jump.back.x)))
y = const(velocity.jump.y)

[State 40, 6]
type = ChangeState
trigger1 = AnimTime = 0
value = 50
ctrl = 1

;---------------------------------------------------------------------------
; BJump
[Statedef 42]
type    = S
physics = S
anim = 40
ctrl = 0
sprpriority = 1
facep2 = 1

[State 40, 1]
type = VarSet
trigger1 = 1
sysvar(1) =-1

[State 0, VelSet]
type = VelSet
trigger1 = AnimElemtime(1)>0
x = 0 

[State 40, 4]
type = VelSet
trigger1 = AnimTime = 0
x = ifelse(sysvar(1)=0, const(velocity.jump.neu.x), ifelse(sysvar(1)=1, const(velocity.jump.fwd.x), const(velocity.jump.back.x)))
y = const(velocity.jump.y)

[State 40, 5]
type = VelSet
trigger1 = AnimTime = 0
trigger1 = prevstateno = 100 ;RUN_FWD
trigger1 = sysvar(1) = 1
x = const(velocity.runjump.fwd.x)

[State 40, 6]
type = ChangeState
trigger1 = AnimTime = 0
value = 50
ctrl = 1

;---------------------------------------------------------------------------
; NJump
[Statedef 43]
type    = S
physics = S
anim = 40
ctrl = 0
sprpriority = 1
facep2 = 1

[State 40, 1]
type = VarSet
trigger1 = 1
sysvar(1) =0

[State 0, VelSet]
type = VelSet
trigger1 = AnimElemtime(1)>0
x = 0 

[State 40, 4]
type = VelSet
trigger1 = AnimTime = 0
x = ifelse(sysvar(1)=0, const(velocity.jump.neu.x), ifelse(sysvar(1)=1, const(velocity.jump.fwd.x), const(velocity.jump.back.x)))
y = const(velocity.jump.y)

[State 40, 5]
type = VelSet
trigger1 = AnimTime = 0
trigger1 = prevstateno = 100 ;RUN_FWD
trigger1 = sysvar(1) = 1
x = const(velocity.runjump.fwd.x)

[State 40, 6]
type = ChangeState
trigger1 = AnimTime = 0
value = 50
ctrl = 1

;---------------------------------------------------------------------------
; SFJump
[Statedef 44]
type    = S
physics = S
anim = 40
ctrl = 0
sprpriority = 1
facep2 = 1

[State 40, 1]
type = VarSet
trigger1 = 1
sysvar(1) =1

[State 0, VelSet]
type = VelSet
trigger1 = AnimElemtime(1)>0
x = 0 

[State 40, 4]
type = VelSet
trigger1 = AnimTime = 0
x = ifelse(sysvar(1)=0, const(velocity.jump.neu.x), ifelse(sysvar(1)=1, const(velocity.jump.fwd.x), const(velocity.jump.back.x)))
y = const(velocity.jump.y)

[State 40, 5]
type = VelSet
trigger1 = AnimTime = 0
x = const(velocity.runjump.fwd.x)

[State 40, 6]
type = ChangeState
trigger1 = AnimTime = 0
value = 50
ctrl = 1

;---------------------------------------------------------------------------
; Jump Up
[Statedef 50]
type    = A
physics = A

[State 50, Dust FX Jump Fwd Jump & Backwards Jump]
type = Explod
triggerall = animelemtime(1)=1
trigger1 = anim = 41 || anim = 42 || anim = 43
anim = 6000
ID = 6000
pos = 0,40
postype = p1  ;p2,front,back,left,right
facing = ifelse (anim = 43,-1,1)
bindtime = 1
persistent = 0
ownpal = 1
scale = 1,1
sprpriority = 2

[State 50, 1]
type = VarSet
trigger1 = Time = 0
sysvar(1) = 0

[State 50, 2]
type = ChangeAnim
trigger1 = Time = 0
value = ifelse((vel x)=0, 41, ifelse((vel x)>0, 42, 43))

[State 50, 3]
type = ChangeAnim
trigger1 = Vel y > Const720p(-8)
trigger1 = SelfAnimExist(anim + 3)
trigger1 = anim >= 41 && anim <= 43
persistent = 0
value = Anim + 3

[State 50, Jump Sound]
type = PlaySnd
trigger1 = Time = 0
value = 41, 0

;---------------------------------------------------------------------------
; Jump Land
[Statedef 52]
type    = S
physics = S
ctrl = 0
anim = 47

[State 52, Dust FX Jump Land]
type = Explod
trigger1 = time = 0
anim = 6002
ID = 6002
pos = 0,0
postype = p1  ;p2,front,back,left,right
facing = 1
bindtime = 1
ownpal = 1
scale = 1,1
sprpriority = 0

[State 52, 1]
type = VelSet
trigger1 = Time = 0
y = 0

[State 52, 2]
type = PosSet
trigger1 = Time = 0
y = 0

[State 52, 3]
type = CtrlSet
trigger1 = Time = 3
value = 1

[State 52, 4]
type = VelSet
trigger1 = 1
x = 0

[State 52, Landing Sound]
type = PlaySnd
trigger1 = Time = 0
value = 47, 0

[State 52, 5]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1

;---------------------------------------------------------------------------
;Run Forward
[Statedef 100]
type    = S
physics = S
anim = 100
sprpriority = 1
ctrl = ifelse(var(59),0,1)

[State 100, 1]
type = VelSet
trigger1 = 1
x = const(velocity.run.fwd.x)

[State 100, Dust FX Run Fwd + Backwards]
type = Explod
trigger1 = time = 0
anim = 6000
ID = 6000
pos = -20,0
postype = p1  ;p2,front,back,left,right
facing = ifelse (anim = 105,-1,1)
bindtime = 1
ownpal = 1
scale = 1,1
sprpriority = 3

[State 100, Dust FX Trail Run]
type = Explod
trigger1 = (time%6) = 0
anim = 6001
ID = 6001
pos = -20,0
postype = p1  ;p2,front,back,left,right
facing = 1
bindtime = 1
ownpal = 1
scale = 1,1
sprpriority = 2

[State 100, 2] ;Prevent run from canceling into walk
type = AssertSpecial
trigger1 = 1
flag = NoWalk

[State 100, 3] ;Prevent from turning
type = AssertSpecial
trigger1 = 1
flag = NoAutoTurn

[State 100, Helper]
type = Helper
trigger1 = (Time%4 = 0)
name = "Afterimages Helper"
ID = 104
stateno = 104
postype = p1
pos = 0,0
facing = 1
keyctrl = 0
ownpal = 1
supermovetime = 0
pausemovetime = 0

[State 101, Jump Sound]
type = PlaySnd
trigger1 = Time = 0
value = 100, 0

[State 100, 4]
type = ChangeState
triggerall = !var(59)
trigger1 = command != "holdfwd"
value = 0
ctrl = 1

[State 100, 3]
type = ChangeState
triggerall = var(59) && var(54) != 2
trigger1 = roundstate != 2 || inguarddist
trigger2 = p2bodydist X <= ifelse(enemynear(var(57)),statetype=L,400,50)
value = 0
ctrl = 1

[State 100, 3]
type = ChangeState
triggerall = var(59) && var(54) = 2
trigger1 = roundstate != 2
trigger2 = p2bodydist X <= 50
value = 0
ctrl = 1

;---------------------------------------------------------------------------
; Hop backwards (Start)
[Statedef 105]
type    = C
physics = C
ctrl = 0
anim = 47
sprpriority = 2

[State 105, NotHitBy]
type = NotHitBy
trigger1 = time < 6
value = SCA,NA,SA,HA,NP,SP,HP,NT,ST,HT
;value2 = S,NA

[State 105, Dust FX Run Fwd + Backwards]
type = Explod
trigger1 = time = 0
anim = 6000
ID = 6000
pos = 20,0
postype = p1  ;p2,front,back,left,right
facing = ifelse (anim = 47,-1,1)
bindtime = 1
ownpal = 1
scale = 1,1
sprpriority = 3

[State 105, Helper]
type = Helper
trigger1 = (Time%4 = 0)
name = "Afterimages Helper"
ID = 104
stateno = 104
postype = p1
pos = 0,0
facing = 1
keyctrl = 0
ownpal = 1
supermovetime = 0
pausemovetime = 0

[State 105, Jump Sound]
type = PlaySnd
trigger1 = Time = 0
value = 41, 0

[State 105, 3]
type = ChangeState
trigger1 = time = 3
value = 106
ctrl = 0

;---------------------------------------------------------------------------
; Hop backwards (Continued)
[Statedef 106]
type    = A
physics = A
ctrl = 0
anim = 105
sprpriority = 2

[State 106, PlayerPush]
type = PlayerPush
trigger1 = 1
value = 0

[State 106, Helper]
type = Helper
trigger1 = (Time%4 = 0)
name = "Afterimages Helper"
ID = 104
stateno = 104
postype = p1
pos = 0,0
facing = 1
keyctrl = 0
ownpal = 1
supermovetime = 0
pausemovetime = 0

[State 106, NotHitBy]
type = NotHitBy
trigger1 = time < 6
value = SCA,NA,SA,HA,NP,SP,HP,NT,ST,HT
;value2 = S,NA

[State 106, 1]
type = VelSet
trigger1 = Time = 0
x = const(velocity.run.back.x)
y = const(velocity.run.back.y)

[State 106, 2]
type = CtrlSet
trigger1 = 1
value = 0

[State 106, 3]
type = ChangeState
trigger1 = Vel Y > 0
trigger1 = Pos Y >= 0
value = 52

;---------------------------------------------------------------------------
; Downed get-hit (hit ground from fall)
[Statedef 5100]
type    = L
movetype= H
physics = N

[State 5100, EnvShake]
type = FallEnvShake
trigger1 = Time = 0

[State 5100, Var] ;Save fall velocity
type = VarSet
trigger1 = Time = 0
sysvar(1) = floor(vel y)

[State 5100, 2] ;Hit ground anim (normal)
type = ChangeAnim
triggerall = time = 0
trigger1 = (anim != [5051,5059]) && (anim != [5061,5069])
trigger2 = !SelfAnimExist(5100 + (anim % 10))
value = 5100

[State 5100, 3] ;Hit ground anim (for hit up)
type = ChangeAnim
trigger1 = time = 0
trigger1 = (anim = [5051,5059]) || (anim = [5061,5069])
trigger1 = SelfAnimExist(5100 + (anim % 10))
value = 5100 + (anim % 10)

[State 5100, 4]
type = PosSet
trigger1 = Time = 0
y = 0

[State 5100, 5]
type = VelSet
trigger1 = Time = 0
y = 0

[State 5100, 6] ;Reduce speed
type = VelMul
trigger1 = Time = 0
x = 0.75

[State 5100, 7]
type = ChangeState
trigger1 = Time = 0
trigger1 = GetHitVar(fall.yvel) = 0
value = 5110 ;Downed get-hit (lying down)

[State 5100, 8]
type = Explod
trigger1 = Time = 1
anim = 8600
postype = p1
pos = 0,0
scale = 1,1
facing = facing
sprpriority = 0
ownpal = 1

[State 5100, 9]
type = HitFallDamage
trigger1 = Time = 3

[State 5100, 10]
type = PlaySnd
trigger1 = Time = 1
value = F7, (sysvar(1) > Const720p(20)) + (sysvar(1) > Const720p(56))

[State 5100, 11]
type = PosFreeze
trigger1 = 1

[State 5100, 12]
type = ChangeState
trigger1 = AnimTime = 0
value = 5101 ;Downed get-hit (bounce off ground)

[State 5100, 13]
type = ForceFeedback
trigger1 = Time = 0
waveform = sinesquare
ampl = 128,-3,-.2,.005
time = 20

;---------------------------------------------------------------------------
; Downed get-hit (lying down)
[Statedef 5110]
type    = L
movetype= H
physics = N

[State 5110, EnvShake]
type = FallEnvShake
trigger1 = Time = 0

[State 5110, 1] ;For hit up/up-diag type (from state 5081)
type = ChangeAnim
persistent = 0
trigger1 = SelfAnimExist(5110 + (anim % 10))
trigger1 = anim = [5081,5089]
value = 5110 + (anim % 10)

[State 5110, 2] ;Hit ground anim (normal)
type = ChangeAnim
triggerall = time = 0
triggerall = anim != [5110,5119] ;Not already changed anim
trigger1 = anim != [5161,5169]
trigger2 = !SelfAnimExist(5170 + (anim % 10))
value = 5170

[State 5110, 3] ;Hit ground anim (for hit up)
type = ChangeAnim
triggerall = time = 0
triggerall = anim != [5110,5119] ;Not already changed anim
trigger1 = anim = [5161,5169]
trigger1 = SelfAnimExist(5170 + (anim % 10))
value = 5170 + (anim % 10)

[State 5110, 4]
type = HitFallDamage
trigger1 = Time = 0

[State 5110, 5]
type = PosSet
trigger1 = Time = 0
y = 0

[State 5110, Var] ;Get fall velocity
type = VarSet
trigger1 = Time = 0
trigger1 = GetHitVar(fall.yvel) != 0
sysvar(1) = floor(vel y)

[State 5110, 6]
type = PlaySnd
trigger1 = Time = 0
trigger1 = !SysVar(0)
value = F7, (sysvar(1) > Const720p(20)) + (sysvar(1) > Const720p(56))

[State 5110, 7]
type = Explod
trigger1 = Time = 0
trigger1 = !SysVar(0)
anim = 6002
postype = p1
pos = 0,0
scale = 1,1
facing = facing
sprpriority = 0
ownpal = 1

[State 5110, 8]
type = VelSet
trigger1 = Time = 0
y = 0

[State 5110, 9] ;For hit up type
type = ChangeAnim
persistent = 0
triggerall = anim = [5171,5179]
triggerall = SelfAnimExist(5110 + (anim % 10))
trigger1 = AnimTime = 0
trigger2 = SysVar(0) ;SysVar(0) = 1 avoids hit ground anim
value = 5110 + (anim % 10)

[State 5110, 10] ;For normal
type = ChangeAnim
persistent = 0
triggerall = Anim != [5111,5119]
trigger1 = AnimTime = 0
trigger2 = SysVar(0) ;SysVar(0) = 1 avoids hit ground frame
value = 5110

[State 5110, 11] ;If just died
type = ChangeState
triggerall = !alive
trigger1 = AnimTime = 0
trigger2 = SysVar(0) ;SysVar(0) = 1 avoids hit ground frame
trigger3 = Anim = [5110,5119]
value = 5150

[State 5110, 12]
type = VarSet
trigger1 = SysVar(0)
trigger1 = Time = 0
sysvar(0) = 0

[State 5110, 13] ;Friction
type = VelMul
trigger1 = 1
x = 0.85

[State 5110, 14] ;Friction
type = VelSet
trigger1 = abs(Vel x) < Const(movement.down.friction.threshold)
persistent = 0
x = 0

[State 5110, 15]
type = ForceFeedback
trigger1 = alive
trigger1 = Time = 0
time = 8
ampl = 240
waveform = sine

[State 5110, 16]
type = ForceFeedback
trigger1 = !alive
trigger1 = Time = 0
ampl = 200, 7, -.467
time = 30
waveform = sine

;---------------------------------------------------------------------------
; Air get-hit (fall recovery on ground)
[Statedef 5201]
type    = S
movetype= H
physics = N
anim = 5200

[State 5201, 1] ;Turn if not facing opponent
type = Turn
trigger1 = Time = 0
trigger1 = p2dist X < Const720p(-20)

[State 1205, Snd]
type = PlaySnd
trigger1 = AnimElem = 1
value = 47,0

[State 5201, VelSet]
type = VelSet
trigger1 = AnimElemTime(1)< 3
x = const(velocity.run.back.x)
y = 0
;ignorehitpause = 
;persistent = 

[State 5201, VelSet End]
type = VelSet
trigger1 = AnimElem = 8
x = 0
y = 0
;ignorehitpause = 
;persistent = 

[State 5201, 3]
type = PosSet
trigger1 = time = 0
y = 0

[State 0, VelAdd]
type = VelAdd
trigger1 = AnimElem = 4
x = 0

[State 5201, 4]
type = NotHitBy
trigger1 = 1
value = SCA
time = 1

[State 5201, 5] ;Blink white
type = PalFX
trigger1 = Time = 0
time = 3
add = 128,128,128 ;256,256,256

[State 5201, Dust FX]
type = Explod
trigger1 = time = 0
anim = 6002
pos = 0,0
postype = p1  ;p2,front,back,left,right
facing = 1
bindtime = 1
ownpal = 1
scale = 1,1
sprpriority = 0

[State 5201, Voice]
type = PlaySnd
trigger1 = time = 0
value = 5200, 0
channel = 0

[State 5201 ChangeState]
type = ChangeState
trigger1 = AnimTime = 0
value = 0
ctrl = 1
